<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Invitation extends Model 
{

    protected $table = 'invitations';
    public $timestamps = true;

    public function owner()
    {
        return $this->belongsTo('App\Models\User', 'id');
    }

    public function applies()
    {
        return $this->hasMany('App\Models\Apply', 'invitation_id');
    }

    public function comments()
    {
        return $this->hasMany('App\Models\Comment');
    }

}